;===========================================================================
.include "d:\avr\avrasm\appnotes\tn2313def.inc"
;===========================================================================
.def     Temp=R16
.def     VAR=R17
.def     REGB=R18
.def     REGD=R19
.def     CONTR1=R20
.def     CONTR2=R21
.def     REGBON=R22
.def     REGDON=R23
.def     REGBOFF=R24
.def     REGDOFF=R25
.def     TEMPER=R26
;===========================================================================
.cseg
.org 0
rjmp Reset
rjmp INT_0
rjmp INT_1
rjmp Timer1_capt1
rjmp Timer1_comp1
rjmp Timer1_OVF1
rjmp Timer0_OVF0
rjmp UART_RX
rjmp UART_UDRE
rjmp UART_TX
rjmp ANA_COMP
;Reset: 
INT_0:
;INT_1:
Timer1_capt1:
;Timer1_comp1:
Timer1_OVF1:
Timer0_OVF0:
UART_RX:
UART_UDRE:
UART_TX:
ANA_COMP:
reti
;===========================================================================
RESET:

ldi VAR,RamEnd          ;
out SPL,VAR

ldi Temp,0b00101000     ; sleep,  INT1      
out MCUCR,Temp

ldi Temp,0b00011111
out DDRB,Temp
ldi Temp,0b00110100
out DDRD,Temp

ldi REGBON,0b01000000
ldi REGDON,0b00010000
ldi REGBOFF,0b00000000
ldi REGDOFF,0b00010001

ldi Temp,0b00001000
out PortD,Temp
ldi Temp,0b00000000
out PortB,Temp

ldi Temper,0b00000100
;ldi Temper,0b00101000

sei
;===========================================================================
MAIN:

;ldi Temp,0b00000001
;out PortB,Temp
;rcall Delay0
;ldi Temp,0b00000000
;out PortB,Temp
;rcall Delay0

out PortB,Temper
;ldi Temper,0b00000100
;rcall Delay0

in Temp,GIMSK           ;  INT1
sbr Temp,1<<INT1
out GIMSK,Temp
 
sleep

in Temp,GIMSK           ;  INT1
cbr Temp,1<<INT1
out GIMSK,Temp

rcall Delay0
in VAR,PinD
cpi VAR,0b00000000
brne MAIN

rcall Delay
in VAR,PinD
cpi VAR,0b00001000
brne MAIN

rcall Delay
in VAR,PinD
cpi VAR,0b00000000
brne MAIN

rcall Delay
rcall LAODB
rcall LAODB
rcall LAODB
rcall LAODB
rcall LAODB
rcall LAODB
rcall LAODB
andi REGB,0b01111110
rcall LOADD
rcall LOADD
rcall LOADD
rcall LOADD
rcall LOADD
lsr REGD
lsr REGD
andi REGD,0b00011111

ldi TEMPER,0b00000100
;ldi TEMPER,0b00101000

cp REGB,REGBON
brne OB1
cp REGD,REGDON
brne OB1
rcall SWITCH_ON
rjmp MAIN

OB1:

cp REGB,REGBOFF
brne MAIN
cp REGD,REGDOFF
brne MAIN
rcall SWITCH_OFF
rjmp MAIN

;===========================================================================
SWITCH_ON:
;ldi Temper,0b00001100
ldi Temper,0b00000001
;out PortB,Temp
ret
;===========================================================================
SWITCH_OFF:
;ldi Temper,0b00011000
ldi Temper,0b00000010
;out PortB,Temp
ret
;===========================================================================
LAODB:
in Temp,PinD
lsl Temp
lsl Temp
lsl Temp
lsl Temp
or REGB,Temp
lsr REGB
rcall Delay
rcall Delay
ret
;===========================================================================
LOADD:
in Temp,PinD
lsl Temp
lsl Temp
lsl Temp
lsl Temp
or REGD,Temp
lsr REGD
rcall Delay
rcall Delay
ret
;===========================================================================
Timer1_comp1:
reti
;===========================================================================
INT_1:
reti
;===========================================================================
DELAY0:                ; 0,4445 
ldi Temp,0b00000001    ;  = CK f=10 000   T=100 
out TCCR1B,Temp
ldi Temp,0x11          ; ,   4445,   1.778/4=0.4445 
out OCR1AH,Temp
ldi Temp,0x5D
out OCR1AL,Temp
ldi CONTR1,0
ldi Temp,0             ; 
out TCNT1H,Temp
out TCNT1L,Temp
in Temp,TIMSK          ;  Timer1_comp1
sbr Temp,1<<OCIE1A
out TIMSK,Temp
sleep
in Temp,TIMSK          ;  Timer1_comp1
cbr Temp,1<<OCIE1A
out TIMSK,Temp
ret
;===========================================================================
DELAY:
rcall DELAY0
rcall DELAY0
ret
;===========================================================================